clc, clear

LibO = myOutputFile;
LibI = myInterfacciaDAQ;
LibT = myTdmsReader;
Zero = [2.872748438 -0.088105225];

%%
% REAR
% d/L = 50% n600: (37) (77) (87)
% d/L = 50% n800: (39) (79) (89)

% FRONT
% d/L =-50% n600: (47) (67) (57)
% d/L =-50% n800: (49) (69) (59)

ss = cell(5,1);
for K = 1:5  %caso isolato, caso con platooning, costant, sine, 2sine
    ss{K} = LibO.txt2struct([],[],"Scegli file n°"+K);
end

%%
n = 600;

f = figure('name',ss{1}.note,'Color','w');
maxF = 100;

mm = [6,9,16];
for K = 1:5
    
    [smi, tmi, ~] = LibO.extractFromFile( ss{K}.mics );
    
    switch K
        case 1  %isolated
            if n==600
                ok = (tmi>=60+10) & (tmi<=120-10);
            elseif n==800
                ok = (tmi>=180+10) & (tmi<=240-10);
            end
            smi = smi(ok, mm);
            tVet = tmi(ok);
        case 2  %platoon
            if n==600
                ok = (tmi>=60+10) & (tmi<=120-10);
            elseif n==800
                ok = (tmi>=180+10) & (tmi<=240-10);
            end
            smi = smi(ok, mm);
            tVet = tmi(ok);
        case {3,4,5}
            ok = (tmi>=25) & (tmi<=50);
            smi=smi(ok,mm);
            tVet = tmi(ok);
    end
    filterMic = 1;  %(0) no filter, (1) yes filter
    
    if filterMic
        windowCoeff = load('secondo_grup.mat').G2;
        windowCoeff(:,1:8) = load('primo_grup.mat').G1;
        smi = smi - mean(smi);
        for i=1:size(smi,2)
            smi(:,i) = filter( windowCoeff(:,mm(i)),1, smi(:,i) ) * 10;
        end
    end
    
    % %
    for h=1:3
    subplot(4,5,K+5*h)
    plot(tVet-tVet(1), smi(:,h), '-')
    
    xlim([0 25]);
        if h==3
        xlabel('Time [s]')
        else
        xticklabels([])
        end
        drawnow
    end
    
    subplot(4,5,K)
    
    [ccts,ddts]=XCor(smi(:,1),smi(:,2),tVet);
    [cctb,ddtb]=XCor(smi(:,1),smi(:,3),tVet);
    [ccsb,ddsb]=XCor(smi(:,2),smi(:,3),tVet);
    
    if K~=1
        yticks([])
    else 
        ylabel({'Side Microphone Pressure';'Cross Correlation';'Normalized Coefficients'})  
    end

    
    [~,j(1)]=max(ccts);
    [~,j(2)]=max(cctb);
    [~,j(3)]=max(ccsb);
    plot(ddts,ccts,':','Marker','o','MarkerFaceColor','auto','MarkerIndices',j(1)); hold on
    plot(ddts,cctb,':','Marker','o','MarkerFaceColor','auto','MarkerIndices',j(2)); 
    plot(ddts,ccsb,':','Marker','o','MarkerFaceColor','auto','MarkerIndices',j(3)); 
    xlim([-1 1]*(1+(K>2)*7))
    xticks auto
    xlabel('delay \tau [s]')
    ylim auto
    % %
    subplot(4,5,K)
    switch K
        case 1
            title('ISOLATED Truck')
        case 2
            title('PLATOON Test')
        case 3
            title({'PLATOON + FORCING';'(Constant Signal)'})
        case 4
            title({'PLATOON + FORCING';'(Sinusoidal Signal)'})
        case 5
            title({'PLATOON + FORCING';'(Double Sine Signal)'})
    end
    
    
    drawnow
    
end

subplot(4,5,1)
  ylabel({'Cross Correlation';'Normalized Coefficients'})
  legend({'Top vs Side','Top vs Bot','Side vs Bot'})
subplot(4,5,1+5)
  ylabel({'Pressure Signal';'TOP Mic. [Pa]'})
subplot(4,5,1+10)
  ylabel({'Pressure Signal';'SIDE Mic. [Pa]'})
subplot(4,5,1+15)
  ylabel({'Pressure Signal';'BOT Mic. [Pa]'})  
%%
function [a,b]=XCor(s1,s2,tmi)
maxDel = round(8 /(tmi(2)-tmi(1)));
[a,b] = xcorr(s1, s2, maxDel,'coef');
b = b*(tmi(2)-tmi(1));
end
